/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.19)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define N 20

#ifdef __STDC__
int randrange(int);
int intcmp(const void *, const void *);
#endif

int intcmp();

main()
{
	int a[N], i, nvalues = N;

	srand((unsigned int)time((time_t *)NULL));

	/* przestawianie elementw tablicy, zawierajcej liczby 1..N, */
	/* aby stworzy losow sekwencj tych liczb bez powtrze */

	for(i = 0; i < nvalues; i++)
		a[i] = i + 1;

	for(i = 0; i < nvalues-1; i++) {
		int c = randrange(nvalues-i);
		int t = a[i]; a[i] = a[i+c]; a[i+c] = t;	/* zamiana miejscami */
	}
	for(i = 0; i < N; i++)
		printf("%d\n", a[i]);

	/* weryfikujemy przestawienie sortujc z powrotem, aby uzyska oryginalne ustawienie */

	qsort(a, nvalues, sizeof(int), intcmp);

	for(i = 0; i < nvalues; i++)
		if(a[i] != i + 1)
			printf("bd: a[%d] = %d\n", i, a[i]);

	return 0;
}

randrange(int n)
{
	return rand() / (RAND_MAX / n + 1);
}

int intcmp(const void *p1, const void *p2)
{
	const int *ip1 = p1;
	const int *ip2 = p2;

	if(*ip1 < *ip2) return -1;
	else if(*ip1 > *ip2) return 1;
	else return 0;
}
